package easik.ui;

import java.net.URL;

import javax.help.HelpBroker;
import javax.help.HelpSet;

/**
 * This class is a wrapper class for the JavaHelp documentation.
 * 
 * @author Vera Ranieri 2005
 * @version 2005-08-23 Vera Ranieri
 */
public class Help
{
	/**
	 * The help set associated with this instance of Easik
	 */
	private HelpSet _hs;
	/**
	 * The help broker associated with this instance of Easik
	 */
	private HelpBroker _hb;

	/**
	 * Default constructor for the help frame.
	 */
	public Help()
	{
		String helpHS = "EasikHelp/easik.hs";
		try
		{
			URL hsURL = HelpSet.findHelpSet(null, helpHS);
			_hs = new HelpSet(null, hsURL);
			_hb = _hs.createHelpBroker();
			_hb.setLocation(new java.awt.Point(0,0));
			_hb.initPresentation();
		}
		catch(Exception ee)
		{
			System.out.println("HelpSet " + ee.getMessage());
			System.out.println("HelpSet " + helpHS + " not found");
		}
	}
	
	/**
	 * Causes the help pane to be displayed.
	 */
	public void showHelpIndex()
	{
		_hb.setDisplayed(true);
	}
}
